# TRAE SOLO：AI 主导的全栈开发工具

你好，我是鱼皮。

在前面的文章中，我们学习了各种 AI 编程工具。无论是 Cursor 还是 Claude Code，都是 **人类主导 + AI 辅助** 的模式，你需要不断地和 AI 对话、确认、修改。

但如果你想让 AI 更主动一些，自己规划任务、自动执行开发，该用什么工具呢？

这篇文章，我会介绍 TRAE SOLO，一个让 AI 主导开发任务的全栈开发工具。



## 一、什么是 TRAE SOLO？

[TRAE](https://www.trae.ai/) 是字节跳动推出的 AI 原生编程工具，有 2 种开发模式：

- IDE 模式：类似 Cursor，保留传统开发流程，人类主导
- SOLO 模式：让 AI 主导，自动推进开发任务

所谓 SOLO 模式，是让 **AI 主导任务并自动执行开发**。你只需要有一个想法，然后配合 AI 就能让想法真正落地。

![](https://pic.yupi.icu/1/image-20250928220322788.png)

TRAE SOLO 和 Cursor 的区别是什么？

打个比方，用 Cursor 就像你是项目经理，AI 是程序员，你需要不断地给 AI 分配任务、检查成果、提出修改意见。而用 TRAE SOLO，AI 就是项目经理 + 程序员，你只需要告诉它目标，它会自己规划、自己开发、自己测试。

根据 2026 年的最新评测，TRAE 在 AI 编程软件中表现优异，特别是它的可自定义智能体系统，允许用户像组建团队一样，根据项目需求定义和配置不同角色、技能的 AI 智能体。



## 二、TRAE SOLO 的核心功能

### 1、自动生成文档

TRAE SOLO 会根据你的需求，自动生成：

- 产品需求文档（PRD）
- 技术架构文档
- 接口文档
- 测试报告

这些文档符合企业规范的开发流程，非常专业。



### 2、服务集成能力

TRAE 提供了强大的集成能力，可以傻瓜式接入各种服务：

- Supabase：数据库存储和用户认证
- Stripe：支付功能
- OpenRouter：AI 服务
- Figma：设计原型

不用看官方文档，直接在 TRAE 中点几下就能完成集成。

![](https://pic.yupi.icu/1/image-20250928222329915.png)



### 3、多任务并行

TRAE SOLO 支持多任务并行执行，可以同时开发前端和后端，大大提高效率。



### 4、代码变更工具

TRAE 提供了 DiffView 代码变更工具，可以清晰地看到每次修改了哪些代码，方便审查和回退。



### 5、Plan 模式

除了直接执行，TRAE 还支持 Plan 模式。AI 会先生成详细的执行计划，你确认后再执行。这样可以更好地控制开发过程。



## 三、怎么使用 TRAE SOLO？

让我用一个实际例子来演示 TRAE SOLO 的使用流程。

⭐️ 推荐直接看鱼皮的视频教程，讲解更详细：https://www.bilibili.com/video/BV1yMn3zuE7L



### 准备工作

首先需要准备开发工具：

- 下载安装 [TRAE](https://www.trae.ai/)
- 安装 [Node.js 环境](https://nodejs.org/zh-cn/download)
- 如果要开发小程序，还需要 [微信开发者工具](https://developers.weixin.qq.com/miniprogram/dev/devtools/download.html)

![](https://pic.yupi.icu/1/%E4%B8%8B%E8%BD%BD%E5%B7%A5%E5%85%B7%E6%8B%BC%E5%9B%BE.png)



### 1、需求分析

准备好工具后，进入 TRAE 的 SOLO 模式，打开一个空白的项目文件夹。

![](https://pic.yupi.icu/1/image-20250928220647365.png)

首先我们要进行需求分析。别想的太复杂，只需要把自己的想法用自然语言告诉 AI 就好。

比如我给 AI 提了这样的需求：

```
你是一位专业的程序员，请帮我开发《学习英雄 - AI 问答引导式学习》微信小程序。

用户可以自主设置一个想学习（或测验）的主题，由 AI 围绕主题生成若干个有趣的知识问答卡片，通过闯关答题的形式引导用户更轻松愉快地掌握知识。
```

![](https://pic.yupi.icu/1/image-20250928221154635.png)

AI 很快生成了详细的产品需求文档和技术架构文档，很符合企业规范的开发流程。

![](https://pic.yupi.icu/1/image-20250928221128338.png)

看得出来 AI 已经有些迫不及待想写代码了，但是千万别急，一定要先 **仔细确认需求文档**。

AI 写的还是不错的，但不一定完全符合我们的预期。因此我们要人工重点关注要实现的核心功能，移除掉不需要的附加功能，先确保核心业务流程（P0 级需求）跑通。

![](https://pic.yupi.icu/1/image-20250928221334652.png)

**不要嫌这一步麻烦，现在多花 1 分钟，以后节约 1 小时！** 一定要明确需求，防止 AI 做了不该做的功能。

这里有个小技巧，可以利用 TRAE 集成的 Figma 设计工具，在这里获取到一些免费的产品 UI 原型图。

![](https://pic.yupi.icu/1/image-20250928221519374.png)

可以点击查看某个原型具体的设计，只需要选中你看上的原型图，点击添加到对话，TRAE 就会自动把原型图关联到发给 AI 的对话中。

![](https://pic.yupi.icu/1/image-20250928221618668.png)



### 2、方案设计

下面我们要进行方案设计，这以前是月薪几万的架构师干的活，现在让小 AI 帮我们 SOLO。

编写这段 Prompt 时一定要注意几个细节，**遵循最小化开发原则**，防止 AI 把简单的事情搞复杂。

```
我已经人工调整了产品需求文档，移除了很多不必要的功能。请你根据我人工修改过的需求，重新生成技术架构文档。要求：
1. 禁止增加需求文档中没有提到的功能
2. 遵循最小化开发原则，以实现功能为主，禁止提供实现功能之外的扩展，比如部署、监控、限流等
3. 遵循前后端分离原则
```

很快 AI 生成了完整的技术架构文档，包括用什么前端和后端技术、接口怎么设计、数据表怎么设计等等。

![](https://pic.yupi.icu/1/image-20250928221924096.png)

这里我建议能看懂文档的同学还是多发挥一些专业性，明确具体的技术选型，让 AI 生成的代码在自己的可控范围内。比如我明确项目使用 Supabase 数据库、使用 OpenRouter 对接 Gemini 大模型提供 AI 服务。

![](https://pic.yupi.icu/1/image-20250928221952548.png)

看不懂文档的同学也不用担心，你就把自己想象成老板或者产品经理，程序员同事吭哧吭哧拿了份技术方案给你，你就说 "怎么实现我不管，这个需求明天上线！" 让他放手干就完了。

你要相信 AI，相信相信的力量。



### 3、服务集成

完成了方案设计，在正式进入开发前，我们还要准备项目依赖的服务。

把用户数据存储在哪里？怎么让程序对接 AI 大模型？这都是我们要解决的问题。

相比于自己手动安装服务，可以直接使用 TRAE 提供的集成能力，不用专门去看官方文档对接服务，直接傻瓜式安装。

![](https://pic.yupi.icu/1/image-20250928222329915.png)

#### 集成 Supabase

[Supabase](https://supabase.com/) 是开源的后端即服务（BaaS）平台，提供数据库存储、用户身份验证、即时 API 等功能。

![](https://pic.yupi.icu/1/image-20250928222457606.png)

点击连接按钮，在弹出的页面中完成创建 Supabase 账号、创建组织、以及认证授权。

![](https://pic.yupi.icu/1/image-20250928222520491.png)

然后进入到 TRAE，看到组织成功显示后，点击创建一个新项目，填写一些项目配置信息，然后点击创建。

![](https://pic.yupi.icu/1/image-20250928222545479.png)

创建项目后回到 TRAE 刷新一下，点击连接就可以了，就这么简单。

![](https://pic.yupi.icu/1/image-20250928222608471.png)

如果说之前 AI Vibe Coding 让后端开发者爽翻了，那这波可以说是前端开发者赢麻了，简单的项目都不用自己搭建后端了。



#### 集成 OpenRouter AI 服务

TRAE 能够和多种 AI 服务集成，这里我选择 [OpenRouter](https://openrouter.ai/)，它的优点是可以通过统一的 API 对接各家大模型，比如 Gemini、GPT、Claude 等等。

![](https://pic.yupi.icu/1/image-20250928222649319.png)

首先到官网注册登录账号，然后进入 API Keys 页面创建一个调用 AI 的密钥，然后在 TRAE 中配置并填写密钥，AI 服务就已经集成完毕了。

![](https://pic.yupi.icu/1/image-20250928222833273.png)

但是注意，要确保你有足够的用量，否则可能调用失败，或者报错调用频率太频繁。

![](https://pic.yupi.icu/1/image-20250928222853247.png)



### 4、后端开发

准备工作完成后，我们终于要进入紧张刺激的开发环节了。

这里要注意，由于 **AI 的上下文是有限的**，为了能更好地生成完整项目、减少 Bug，建议分个步骤：先生成后端代码，人工校验通过后，再生成前端代码。

给 AI 输入提示词，先开发后端，确保项目可以正常运行：

```
请你基于最新的产品需求文档和技术架构文档进行开发，优先开发后端，确保项目可以正常运行
```

我们可以使用 TRAE 提供的 Prompt 优化功能来一键优化提示词。

![](https://pic.yupi.icu/1/%E4%BC%98%E5%8C%96%E6%8F%90%E7%A4%BA%E8%AF%8D.png)

点击执行，请开始你的 SOLO。AI 会先给出任务计划：

![](https://pic.yupi.icu/1/image-20250928224232897.png)

然后自主操作终端执行命令、编写后端配置文件和业务逻辑代码、编写数据库建表语句等等，重要操作还会找我们主动确认，非常严谨。

![](https://pic.yupi.icu/1/image-20250928224300188.png)

看不懂也没关系，让它放手干吧。

等待期间，你可以到 [编程导航](https://codefather.cn/) 上看看免费的编程学习路线。TRAE 自带消息通知功能，AI 完成任务后会提醒我们。

我感觉 TRAE 调教 AI 还是有一套的，它会自己验证程序是否正常。

![](https://pic.yupi.icu/1/image-20250928224350332.png)

一段时间后，AI 生成完毕，不仅生成了代码，还很贴心地生成了后端的接口文档。

![](https://pic.yupi.icu/1/image-20250928224437599.png)



### 5、前端开发

下面进行前端开发。

这里一定要注意，不要接着之前的对话继续写提示词了。

为什么呢？因为 AI 大模型的上下文是有限的，前面的操作已经消耗了不少上下文。为了防止 AI 上下文不足或者记忆混乱，我们生成前端时，重新开一个干净的对话来编写提示词。

![](https://pic.yupi.icu/1/image-20250928224735250.png)

提示词中提供给 AI 产品需求文档、技术架构文档和后端接口文档，就可以让 AI 专注于前端代码生成。

```
你是一位专业的程序员，请帮我开发《学习英雄 - AI 问答引导式学习》微信小程序。

用户可以自主设置一个想学习（或测验）的主题，由 AI 围绕主题生成若干个有趣的知识问答卡片，通过闯关答题的形式引导用户更轻松愉快地掌握知识。

请你根据 @产品需求文档 @技术架构文档 @后端接口文档，帮我生成完整可运行的微信小程序前端代码。
注意：
1. 遵循最小功能原则，不要额外开发需求文档没提到的任何功能
2. 如果需要显示图片，请使用占位图片 picsum.photos 代替（比如 picsum.photos/200/300）
```

好，执行！

等待期间，你可以到 [面试鸭](https://www.mianshiya.com/) 上看看免费的面试题和刷题路线。

一段时间后，AI 生成完毕，一次性 SOLO 出了 20 多个文件！

![](https://pic.yupi.icu/1/image-20250928224830751.png)

虽然看着很爽，但老实说我是有点慌的，不知道能不能正常运行。



### 6、测试验证

下面我们来到了激动人心的测试验证环节。

首先需要打开微信开发者工具，导入已有项目文件夹，先选择使用测试号开发调试项目。

![](https://pic.yupi.icu/1/image-20250928225118198.png)

打开项目后，我们先点击右上角的 "测试号"，按照 [文档](https://developers.weixin.qq.com/miniprogram/dev/devtools/sandbox.html) 的指引获取到测试号的 AppID 和 AppSecret 密钥：

![](https://pic.yupi.icu/1/image-20250928225220066.png)

然后手动填入到后端配置文件中，否则将无法正常微信登录。

![](https://pic.yupi.icu/1/image-20250928225304614.png)

然后我们就可以编译运行项目了。

结果，果然报错了！

![](https://pic.yupi.icu/1/image-20250928225522618.png)

意料之中，意料之中。小程序开发比网页开发还是更难一些的，毕竟微信开发者工具和文档一直在更新。

![](https://pic.yupi.icu/1/image-20250928225618743.png)

不过没关系，开发过程中难免遇到问题。解决方法很简单，一句话：**报什么错误，就把报错信息发给 AI，让 AI 来修复！**

像我这里遇到了几个典型的问题：

1）图片路径问题：利用 TRAE 的提示词优化功能，能更好地指引 AI 按照指定的步骤修复 Bug

![](https://pic.yupi.icu/1/image-20250928225717687.png)

2）登录失败问题：点击开发者工具右上角的 “详情”，进入到本地设置中，勾选 “不校验合法域名”

![](https://pic.yupi.icu/1/image-20250928225825654.png)

3）接口路径问题：这可能是由于上下文过长导致的，让 AI 整体修复前端调用后端接口的路径和参数就好

![](https://pic.yupi.icu/1/image-20250928225903118.png)

4）环境配置问题：代码中读取的环境变量名称和配置文件中的不一致，这个问题比较简单，我们可以手动修改。

当我敲了一个字符后，编辑器会自动提示我要修改哪些代码，还支持跨行修改。

![](https://pic.yupi.icu/1/image-20250928225955681.png)

这是 TRAE 提供的 **CUE 功能**，不仅可以帮你自动补全代码、还可以多行修改代码、自动预测未来可能的修改点，尤其适合重构代码的场景，效率起飞。

![](https://pic.yupi.icu/1/%E5%A4%9A%E8%A1%8C%E4%BF%AE%E6%94%B9.gif)

经过一段时间的修复，我们的小程序已经可以正常运行了。虽然现在页面丑丑的，但只要跑通了核心业务流程，用户能正常使用，后续的优化都很简单了。

![](https://pic.yupi.icu/1/image-20250928230045861.png)



### 7、持续优化

最后，如果你要把小程序上线，还是要花一些时间来优化的。

记住，优化前先把现有代码利用 Git 版本控制工具进行托管，并且提交一个基础版本。这样之后优化出了任何问题，都可以一键回滚到老版本。

![](https://pic.yupi.icu/1/image-20250928230154447.png)

像我重点让 AI 帮忙优化了整个小程序的样式风格，只要写一段简单的提示词：

```
你是一位程序员，请你帮我优化整个小程序中每个前端页面和元素的样式风格，使各个页面保持一致。

参考风格：主色调采用活力橙色，清新治愈的卡通风格、简约雅致、让人感到放松愉快。
```

然后利用 TRAE 的提示词优化功能，就能得到一个更详细的优化方案。

![](https://pic.yupi.icu/1/image-20250928230225960.png)

你可以按需调整，也可以让 AI 放手干。

建议大家每进行一次优化或新增一个功能，都提交一次代码，并且适当地新开 AI 对话框，防止上下文过多影响生成的准确度。

最终，你看到的这个小程序，就是我优化后的成品，效果还不错吧。

![](https://pic.yupi.icu/1/image-20250928230316272.png)



## 四、TRAE SOLO 的优缺点

TRAE SOLO 的优势很明显。

首先是 **AI 主导开发**，你不需要不断地和 AI 对话，AI 会自己规划任务、自动执行。而且 **服务集成能力强**，可以傻瓜式接入 Supabase、Stripe 等服务，不用看文档。

还有就是 **文档自动生成**，符合企业规范的开发流程，生成的文档很专业。而且 **国内版访问速度快**，对中文用户友好。

当然也有一些局限。

首先是 **需要一定的引导**，虽然 AI 能自主执行，但你的需求描述越清晰，AI 的执行效果就越好。而且 **生成的代码可能有 Bug**，需要人工测试和修复。

另外，**上下文管理很重要**。如果对话太长，AI 可能会记忆混乱，需要适时新开对话。

价格上，TRAE 有免费版和付费版。免费版有使用限制，付费版根据使用量计费。



## 五、TRAE SOLO 实战建议

如果你想尝试 TRAE SOLO，我有几个建议：

1、明确需求

虽然 AI 能自主规划，但你的需求越明确，AI 的执行效果就越好。建议：

- 清楚说明核心功能
- 移除不必要的功能
- 提供参考设计（如果有的话）
- 明确技术选型（如果你懂的话）



2、分步骤开发

不要一次性让 AI 生成整个项目，而是分步骤：

- 先生成后端，测试通过
- 再生成前端，测试通过
- 最后优化样式和细节

每完成一步，都提交一次代码，这样出问题也能回退。



3、及时修复 Bug

AI 生成的代码可能有 Bug，这很正常。发现问题就立刻让 AI 修复，不要等到最后问题越堆越多。

把报错信息完整地发给 AI，它一般都能修复。



4、控制上下文

对话太长会影响 AI 的准确度。建议：

- 完成一个大功能后，新开对话
- 在新对话中引用之前生成的文档
- 避免在一个对话中做太多事情



## 写在最后

看到这里，相信你已经对 TRAE SOLO 有了全面的了解。

**TRAE SOLO 是 AI 编程工具的一次重要进化**，从 “将 AI 集成到工具中”，进化为 “将开发工具集成到 AI 中”。

![](https://pic.yupi.icu/1/image-20250928220158367.png)

感觉开发工具只是 AI 的一个玩物，它可以自由地操作编辑器、终端、浏览器、文档、集成服务等等来自主完成任务，确实比以前更高效智能了，也能完成包含后端的完整项目。

但是开发过程中大家要注意，现在 **AI 很喜欢把简单的事情搞复杂**，所以最好人工仔细确认需求文档和方案文档，并且像搭积木一样，一步一步地完成开发。

快试试用 TRAE SOLO 做一个小项目，体验一下 AI 主导开发的感觉吧~ 🛫




## 推荐资源

1）鱼皮 AI 导航网站：[AI 资源大全、最新 AI 资讯、免费 AI 教程](https://ai.codefather.cn)

2）编程导航学习圈：[学习路线、编程教程、实战项目、求职宝典、交流答疑](https://www.codefather.cn)

3）程序员面试八股文：[实习/校招/社招高频考点、企业真题解析](https://www.mianshiya.com)

4）程序员写简历神器：[专业模板、丰富例句、直通面试](https://www.laoyujianli.com)

5）1 对 1 模拟面试：[实习/校招/社招面试拿 Offer 必备](https://ai.mianshiya.com)
